### 42.1. 自定义MBean名称

MBean的名称通常产生于端点的id。例如，health端点被暴露为`org.springframework.boot/Endpoint/HealthEndpoint`。

如果你的应用包含多个Spring ApplicationContext，你会发现存在名称冲突。为了解决这个问题，你可以将`endpoints.jmx.uniqueNames`设置为true，这样MBean的名称总是唯一的。

你也可以自定义JMX域，所有的端点都在该域下暴露。这里有个application.properties示例：
```java
endpoints.jmx.domain=myapp
endpoints.jmx.uniqueNames=true
